/*
 * Decompiled with CFR 0.152.
 */
package pse.result;

import org.w3c.dom.Element;
import org.w3c.dom.Node;
import pse.result.IosCommandEntry;
import pse.result.IosEventEntry;
import pse.result.ResultObject;
import pse.util.general.XmlUtils;
import pse.util.general.XmlWriter;

public abstract class IosLogEntry
extends ResultObject {
    protected String device;
    protected String deviceTime;

    public boolean hasAttributes() {
        return true;
    }

    public String getDevice() {
        return this.device;
    }

    public void setDevice(String string) {
        this.device = string;
    }

    public String getDeviceTime() {
        return this.deviceTime;
    }

    public void setDeviceTime(String string) {
        this.deviceTime = string;
    }

    protected void addAttributes(XmlWriter xmlWriter) {
        super.addAttributes(xmlWriter);
        xmlWriter.addAttribute("device", this.device);
        xmlWriter.addAttribute("device-time", this.deviceTime);
    }

    protected void readAttributes(Node node) {
        super.readAttributes(node);
        this.device = XmlUtils.getAttribute(node, "device");
        this.deviceTime = XmlUtils.getAttribute(node, "device-time");
    }

    public static IosLogEntry createFromElement(Element element) {
        IosLogEntry iosLogEntry = null;
        String string = element.getTagName();
        if (string.equals("ios-command")) {
            iosLogEntry = new IosCommandEntry();
        } else if (string.equals("ipc-event")) {
            iosLogEntry = new IosEventEntry();
        } else {
            throw new Error("Unrecognized tag name for IosLogEntry: <" + string + ">");
        }
        iosLogEntry.fromMyNode(element);
        return iosLogEntry;
    }
}

